/*
    4D (the "Software") and the corresponding source code remain
    the exclusive property of 4D and/or its licensors and are protected by national
    and/or international legislations.
    This file is part of the source code of the Software provided under the relevant
    4D License Agreement available on http://www.4D.com/license whose compliance
    constitutes a prerequisite to any use of this file and more generally of the
    Software and the corresponding source code.
 */

$(document).ready(initEventHandler);

function initEventHandler() {
	in4D = (typeof ($4d) != "undefined");
	jQuery.fn['any'] = function() {
    	return (this.length > 0);
  	};  
	var still_need = $('#still_need').attr('data');
	// ACI0088904
	if(still_need == '1') {
		open_menu('menu_title_2');
	} else {
		//ACI0092134		
		try {
			if(document.getElementById("recent_databases").childElementCount > 0) {
				open_menu('menu_title_0');
			}
		}
		catch(err) {
 			open_menu('menu_title_1');	
		}
	}	
	if(in4D) {
		$4d.lic_trial(function(trial) {
			if(trial.length >0) {
				// ACI0093326			
				if(trial == "release") {	
					// $('#2_3').addClass('cached');					
				} else {
					$('#expiration').html(trial);			
					$4d.waString("Lic_Free30dayEvaluation",function(trial)	{
					document.getElementById("2_3").innerHTML = trial;	
					});								
					$('#2_3').removeClass('item');
					$('#2_3').addClass('item-disabled')	
					// ACI0093326		
					$('#2_3').removeClass('cached');
				}
			} else {
				// ACI0093326		
				$('#2_3').removeClass('cached');
				if(still_need != '1') {									
					$('#2_3').removeClass('item');
					$('#2_3').addClass('item-disabled');
				}
			}
		});
	} else {
		var trial = document.getElementById("lic").innerHTML;
		if(trial.length >0) {		
			// ACI0093326
			// if(trial == "release") {	
			if(trial.indexOf("release") !=0) {				
				//$('#2_3').addClass('cached');		
				$('#expiration').addClass('cached');	
			} else {
				document.getElementById("2_3").innerHTML = document.getElementById("lic_comment").innerHTML;						
				$('#2_3').removeClass('item');
				$('#2_3').addClass('item-disabled');	
				document.getElementById("expiration").innerHTML = trial;	
				// ACI0093326
				$('#2_3').removeClass('cached');	
			}
		} else {
			// ACI0093326		
			$('#2_3').removeClass('cached');
			if(still_need != '1') {									
				$('#2_3').removeClass('item');
				$('#2_3').addClass('item-disabled');
				$('#2_3').removeClass('cached');
			}
		}			
	}	
    $('#noMoreLabel').click(noMoreLabel);
    $('#noMore').click(noMore);
    $('#submit').click(freeTrial);
    $('[name="menu-title"]').click(clickMenuTitle);
    $('[name="menu-item"]').click(clickMenuItem);
    $('.info').click(popInfo);
    $('.w-closebox').click(popInfo);
    $('.w-closeLabel').click(popInfo);
    $(document).keydown(keydown);
    // waMessage('loaded');
    return true;
}

function success(msg) {
	$('#freeTrialForm').addClass('cached');
	$('#freeTrialCongatulations').removeClass('cached');
	$('#expiration').removeClass('cached');
	$('#expiration').html(msg);
	if (in4D) {
		$4d.waString("Lic_Free30dayEvaluation",function(trial)	{
			document.getElementById("2_3").innerHTML = trial;	
		});	
	} else {		
		document.getElementById("2_3").innerHTML = document.getElementById("Lic_Free30dayEvaluation").innerHTML;
	}	
	
	// ACI0088904
	//$('#still_need').attr('data','3');
	var x = document.getElementById("still_need");
	x.data = "3";
				
	$('#2_3').removeClass('item');
	$('#2_3').addClass('item-disabled')
}

function evaluation(msg) {
 	$('#expiration').html(msg);
    return true;
}

function keydown(e) {
    if (!e) {
        e = event;
    }

    switch (e.keyCode) {
        // escape
        case 27:
            if (!($('#info_window').hasClass('cached'))) {
                $('#info_window').toggleClass('cached', true);
            } else {
                waMessage('close');
            }
            return suppressdefault(e, document);
            break;
        default:
    }
}

function clickMenuTitle() {
	$('#info_window').addClass('cached');
	open_menu(this.id);	
}

function open_menu(id) {
	switch (id) {
		case 'menu_title_0':
			$('#menu_title_0').removeClass('menu_closed');
			$('#menu_title_0').addClass('menu_opened');
			$('[name=item_0]').removeClass('cached');
			$('[name=item_0]').addClass('displayed')	
			
			$('#menu_title_1').removeClass('menu_opened');
			$('#menu_title_1').addClass('menu_closed');
			$('[name=item_1]').removeClass('displayed');
			$('[name=item_1]').addClass('cached');
			
			$('#menu_title_2').removeClass('menu_opened');
			$('#menu_title_2').addClass('menu_closed');
			$('[name=item_2]').removeClass('displayed');
			$('[name=item_2]').addClass('cached');
			$('#expiration').addClass('cached');
			break;
		case 'menu_title_1':
			$('#menu_title_0').removeClass('menu_opened');
			$('#menu_title_0').addClass('menu_closed');
			$('[name=item_0]').removeClass('displayed');
			$('[name=item_0]').addClass('cached');
			
			$('#menu_title_1').removeClass('menu_closed');
			$('#menu_title_1').addClass('menu_opened');
			$('[name=item_1]').removeClass('cached');
			$('[name=item_1]').addClass('displayed');
			
			$('#menu_title_2').removeClass('menu_opened');
			$('#menu_title_2').addClass('menu_closed');
			$('[name=item_2]').removeClass('displayed');
			$('[name=item_2]').addClass('cached');
			$('#expiration').addClass('cached');
			break;
		case 'menu_title_2':
			$('#menu_title_0').removeClass('menu_opened');
			$('#menu_title_0').addClass('menu_closed');
			$('[name=item_0]').removeClass('displayed');
			$('[name=item_0]').addClass('cached');
			
			$('#menu_title_1').removeClass('menu_opened');
			$('#menu_title_1').addClass('menu_closed');
			$('[name=item_1]').removeClass('displayed');
			$('[name=item_1]').addClass('cached');
			
			$('#menu_title_2').removeClass('menu_closed');
			$('#menu_title_2').addClass('menu_opened');
			$('[name=item_2]').removeClass('cached');
			$('[name=item_2]').addClass('displayed');
			$('#expiration').removeClass('cached');
			break;
		default:
	}
}

function clickMenuItem() {	
	if( this.className.indexOf("item-disabled") == -1 ) {
		var id = this.id;		
		document.getElementById('alert').innerHTML='';
		switch (id) {
			case '1_1':
				waMessage('connectTo4dServer');
				break;
			case '1_2':
				waMessage('openALocalApplication');
				break;
			case '1_3':
				// ACI0088904
				// ACI0092477
				// var x = document.getElementById("still_need");
				var still_need = $('#still_need').attr('data');
				switch (still_need) {
					case '1':						
						var tempo = $('#expiration').html;
						if(tempo.length >0) {			
							waMessage('createANewApplication');	
						} else {
							if (in4D) {
								$4d.waString("Wel_BackgroundaValidLicenseIsRequiredToContinue",function(result)
								{
									document.getElementById('alert').innerHTML=result;
								});
							} else {					
								var tempo = $('#lic_required').html;							
								document.getElementById('alert').innerHTML=tempo;					
							}
						}
						break;
					default:
						waMessage('createANewApplication');				
				}
				break;
			case '2_1':
				waMessage('enterLicence');
				break;
			case '2_2':
				waMessage('purchaseLicence');
				break;
			case '2_3':
				showDialog('info23');
				break;
			case 'trial':
				waMessage('freeTrial/');
				break;
			default:
				waMessage('4dlink_'+$(this).attr('path'));
		}
	}
}

function popInfo() {
    if (this.name == 'closeBox') {
        $('#info_window').addClass('cached');
    } else {        
        toshow = this.value;
        $('#info_window').removeClass('cached');
        $("[name='infos']").each(function() {
            $(this).toggleClass('cached', !($(this).attr("id") == toshow));
        });
    }
}

function showDialog (toshow) {
	$('#info_window').removeClass('cached');
	$("[name='infos']").each(function() {
		$(this).toggleClass('cached', !($(this).attr("id") == toshow));
	});
}

function updateInfo() {
    if (!$('#info_window').hasClass('cached')) {
        wanted = "info" + this.id.replace("_", "");
        $("[name='infos']").each(function() {
            $(this).toggleClass('cached', !($(this).attr("id") == wanted));
        });
    }
}

function noMoreLabel() {
    check('noMore');
    noMore();
}

function noMore() {
    waMessage('NoMore?' + document.getElementById("noMore").checked);
}

function validateMail(adress)  {
	// var reg = new RegExp('^[a-z0-9]+([_|\.|-]{1}[a-z0-9]+)*@[a-z0-9]+([_|\.|-]{1}[a-z0-9]+)*[\.]{1}[a-z]{2,6}$', 'i');
	var reg = new RegExp('^[a-z0-9]+([_|\.|-]{1}[a-z0-9]+)*@[a-z0-9]+([_|\.|-]{1}[a-z0-9]+)*[\.]{1}[a-z]{2,}$', 'i');
	return(reg.test(adress));
}

function freeTrial() {
	var mail = document.getElementById("e_mail");
	var index = document.getElementById("country").selectedIndex;
	var code = document.getElementById("country").options;
	var agree = document.getElementById("IAgree").checked;
	switch (true) {
		case ((mail.value == "") 
				&& (code[index].value == "")):
            waMessage('freeTrial/' + mail.value + "/" + code[index].value);
            break;            
		case (validateMail(mail.value) 
				&& (code[index].value != "")
				&& agree):
            waMessage('freeTrial/' + mail.value + "/" + code[index].value);
            break;            
		case (!validateMail(mail.value)):
			waMessage('freeTrial/error/mail');
    		mail.focus();
        	mail.select();
            break;            
		case (code[index].value == ""):
			waMessage('freeTrial/error/country');
    		document.getElementById("country").focus();
            break;            
		case (!agree):
			waMessage('freeTrial/error/agree');
			document.getElementById("IAgree").focus();
            break;
	}	
}

function doTimer(target) {
    timer_is_on = 1;
    t = setTimeout("displayInfo()", 2000);
}